{$define ilasm}
unit formater;


interface

const NoScale=1;


{Function GetPix(p:pointer,x:word,typ:Byte):longint;}

Type RGB_b=record
	R,G,B:Byte;
	end;
     RGB_w=record
	R,G,B:Word;
	end;

     FPalette=array[0..255] of RGB_b;

type PFormStruct      = ^FormStruct;
     PBasicFormStruct = ^BasicFormStruct;
     FormProc = procedure(FormDesc:PBasicFormStruct;Idata,OData:Pointer);
     BasicFormStruct = object
	Items:Word;
	SrcTyp:char;
	SrcPlanes:byte;
	DestTyp:char;
	DestPlanes:byte;
	Palette:^FPalette;
	Options:Byte;
	end;

     FormStruct = object(BasicFormStruct)
	conv:FormProc;
{       BufData:pointer;
	BufSize:word;
	conv1:FormProc;
	conv2:FormProc;}
       end;


Function InitFormatter(DataCount:Word; SrcTyp:char; SrcPlanes:byte;
		       DestTyp:char; DestPlanes:byte; ConvFlag:Byte):PFormStruct;
Function Pck(Planes:Byte;Typ:char):Byte;

Procedure C_XX_YY(FormDesc:PBasicFormStruct;Idata,OData:Pointer);
Procedure MoveX_X(FormDesc:PBasicFormStruct;Idata,OData:Pointer);

{$ifdef ilAsm}
Procedure conv1_16(FormDesc:PBasicFormStruct;Idata,OData:Pointer);
Procedure conv2_16(FormDesc:PBasicFormStruct;Idata,OData:Pointer);
Procedure conv4_16(FormDesc:PBasicFormStruct;Idata,OData:Pointer);
Procedure conv8_16(FormDesc:PBasicFormStruct;Idata,OData:Pointer);

Procedure conv16_1(FormDesc:PBasicFormStruct;Idata,OData:Pointer);
Procedure conv16_4(FormDesc:PBasicFormStruct;Idata,OData:Pointer);
Procedure conv16_8(FormDesc:PBasicFormStruct;Idata,OData:Pointer);
Procedure conv32_8(FormDesc:PBasicFormStruct;Idata,OData:Pointer);

const GrayProcTable:array[0..6,0..6] of FormProc =
{Dest Pl   1          2          4         8        16        24        32}
{Sr 1}	((MoveX_X,  C_XX_YY,  C_XX_YY,  C_XX_YY,  conv1_16, C_XX_YY,  C_XX_YY),
{Sr 2}	 (C_XX_YY,  MoveX_X,  C_XX_YY,  C_XX_YY,  conv2_16, C_XX_YY,  C_XX_YY),
{Sr 4}	 (C_XX_YY,  C_XX_YY,  MoveX_X,  C_XX_YY,  conv4_16, C_XX_YY,  C_XX_YY),
{Sr 8}	 (C_XX_YY,  C_XX_YY,  C_XX_YY,  MoveX_X,  conv8_16, C_XX_YY,  C_XX_YY),
{Sr 16}	 (conv16_1, C_XX_YY,  conv16_4, conv16_8, MoveX_X,  C_XX_YY,  C_XX_YY),
{Sr 32}	 (C_XX_YY,  C_XX_YY,  C_XX_YY,  conv32_8, C_XX_YY,  MoveX_X,  C_XX_YY),
{Sr 64}	 (C_XX_YY,  C_XX_YY,  C_XX_YY,  C_XX_YY,  C_XX_YY,  C_XX_YY,  MoveX_X));

{$else}

const GrayProcTable:array[0..6,0..6] of FormProc =
{Dest Pl   1          2          4         8        16        24        32}
{Sr 1}	((MoveX_X,  C_XX_YY,  C_XX_YY,  C_XX_YY,  C_XX_YY,  C_XX_YY,  C_XX_YY),
{Sr 2}	 (C_XX_YY,  MoveX_X,  C_XX_YY,  C_XX_YY,  C_XX_YY,  C_XX_YY,  C_XX_YY),
{Sr 4}	 (C_XX_YY,  C_XX_YY,  MoveX_X,  C_XX_YY,  C_XX_YY,  C_XX_YY,  C_XX_YY),
{Sr 8}	 (C_XX_YY,  C_XX_YY,  C_XX_YY,  MoveX_X,  C_XX_YY,  C_XX_YY,  C_XX_YY),
{Sr 16}	 (C_XX_YY,  C_XX_YY,  C_XX_YY,  C_XX_YY,  MoveX_X,  C_XX_YY,  C_XX_YY),
{Sr 32}	 (C_XX_YY,  C_XX_YY,  C_XX_YY,  C_XX_YY,  C_XX_YY,  MoveX_X,  C_XX_YY),
{Sr 64}	 (C_XX_YY,  C_XX_YY,  C_XX_YY,  C_XX_YY,  C_XX_YY,  C_XX_YY,  MoveX_X));

{$endif}



(*
const ColorProcTabe:array[0..3,0..3] of FormProc =
{Dest Pl  RGB8       RGB16   RGB24    RGB48    }
{Sr 8}	((MoveX_X,   C_XX_YY,     C_XX_YY,     C_XX_YY),
{Sr 16}	 (C_XX_YY,     MoveX_X,   C_XX_YY,     C_XX_YY),
{Sr 24}	 (C_XX_YY,       C_XX_YY,   MoveX_X,   C_XX_YY),
{Sr 48}	 (C_XX_YY,       C_XX_YY,     C_XX_YY,   MoveX_X));

*)


implementation


Function Pck(Planes:Byte;Typ:char):Byte;
begin
pck:=0;
if(typ='G')or(typ='B') then
	begin
	case Planes of 1:exit;
		       2:begin;pck:=1;exit;end;
		       4:begin;pck:=2;exit;end;
		       8:begin;pck:=3;exit;end;
		      16:begin;pck:=4;exit;end;
		      24:begin;pck:=5;exit;end;
		      32:begin;pck:=6;exit;end;
		    end;
	exit;
	end;

end;

Function EmptyFormatter(DataCount:Word):PFormStruct;
var str:PFormStruct;
begin
 new(str);
 fillchar(str^,sizeof(str^),0);

 str^.Items:=DataCount;
 str^.Options:=0;
 EmptyFormatter:=str;
end;


Function InitFormatter(DataCount:Word; SrcTyp:char; SrcPlanes:byte;
		       DestTyp:char; DestPlanes:byte; ConvFlag:Byte):PFormStruct;
var str:PFormStruct;
    s1,d1:Byte;
begin
 new(str);

 str^.SrcTyp:=SrcTyp;
 str^.SrcPlanes:=SrcPlanes;
 str^.DestTyp:=DestTyp;
 str^.DestPlanes:=DestPlanes;
 str^.Options:=ConvFlag;
 str^.Items:=DataCount;
 str^.Palette:=nil;


 s1:=pck(SrcPlanes,SrcTyp);
 d1:=pck(DestPlanes,DestTyp);

 str^.conv:=C_XX_YY;
 if ((SrcTyp='G') or (SrcTyp='B'))and ((DestTyp='G') or (DestTyp='B'))
	then begin
	     str^.conv:=GrayProcTable[s1,d1];
	     end;


 InitFormatter:=str;
end;


{$ifdef ilAsm}
{----Vykonne procedury---}
Procedure conv1_16(FormDesc:PBasicFormStruct;Idata,OData:Pointer);
var MaxX:Word;
begin
MaxX:=FormDesc^.Items;
asm
	PUSH	ES
	PUSH	DS
	CLD		{auto increment}
	LES	DI,OData
	LDS	SI,Idata
	XOR	CX,CX
@Loop1: MOV	BL,byte ptr DS:SI
	INC	SI
@Lop1:	XOR	AX,AX
	SHL	BL,1
	ADC	AL,0
	STOSW
	INC	CX
	CMP	CX,word ptr MaxX
	JGE	@Konec1
	TEST	CX,7
	JNZ	@Lop1
	JMP	@Loop1
@Konec1:POP	DS
	POP	ES
	end;
end;


Procedure conv2_16(FormDesc:PBasicFormStruct;Idata,OData:Pointer);
var MaxX:Word;
begin
MaxX:=FormDesc^.Items;
	asm
	PUSH	ES
	PUSH	DS
	CLD		{auto increment}
	MOV	CX,word ptr maxX
	LES	DI,OData
	LDS	SI,IData
	XOR	AX,AX
@Loop2: MOV	AL,byte ptr DS:SI
	MOV	DL,AL
	SHR	AL,6
	STOSW
	DEC	CX
	JCXZ	@Konec2
	MOV	AL,DL
	SHR	AL,4
	AND	AL,3
	STOSW
	DEC	CX
	JCXZ	@Konec2
	MOV	AL,DL
	SHR	AL,2
	AND	AL,3
	STOSW
	DEC	CX
	JCXZ	@Konec2
	LODSB
	AND	AL,03
	STOSW
	LOOP	@Loop2
@Konec2:POP	DS
	POP	ES
	end;
end;

Procedure conv4_16(FormDesc:PBasicFormStruct;Idata,OData:Pointer);
var MaxX:Word;
begin
MaxX:=FormDesc^.Items;
	asm
	PUSH	ES
	PUSH	DS
	CLD		{auto increment}
	MOV	CX,word ptr maxX
	LES	DI,OData
	LDS	SI,Idata
	XOR	AX,AX
@Loop4: MOV	AL,byte ptr DS:SI
	SHR	AL,4
	STOSW
	DEC	CX
	JCXZ	@Konec4
	LODSB
	AND	AL,0Fh
	STOSW
	LOOP	@Loop4
@Konec4:POP	DS
	POP	ES
	end;
end;

Procedure conv8_16(FormDesc:PBasicFormStruct;Idata,OData:Pointer);
var MaxX:Word;
begin
MaxX:=FormDesc^.Items;
	asm
	xor ax,ax
	PUSH	ES
	PUSH	DS
	CLD		{auto increment}
	MOV	CX,word ptr maxX
	LES	DI,OData
	LDS	SI,Idata

@@Loop8:LODSB
	STOSW
	LOOP	@@Loop8

	POP	DS
	POP	ES
	end;
end;


Procedure conv16_1(FormDesc:PBasicFormStruct;Idata,OData:Pointer);
var MaxX:Word;
begin
MaxX:=FormDesc^.Items;
	asm
	PUSH	ES
	PUSH	DS
	CLD		{auto increment}
	MOV	CX,word ptr maxX
	MOV	BX,0080h	{BH je stradac a v BL je maska}
	LES	DI,Odata
	LDS	SI,Idata
@@Loop:	LODSW
	OR	AX,AX
	JZ	@@Nic
	OR	BH,BL		{propis Bit}
@@Nic:	SHR	BL,1
	JNZ	@@Neopr
	MOV	AL,BH		{hotovy dalsi Byte}
	STOSB
	MOV	BX,0080h
	LOOP	@@Loop
	JMP	@@End
@@Neopr:LOOP	@@Loop
	MOV	AL,BH
	STOSB			{uloz nedokonceny byte}
@@End:	POP	DS
	POP	ES
	end;
end;

Procedure conv16_4(FormDesc:PBasicFormStruct;Idata,OData:Pointer);
var MaxX:Word;
begin
MaxX:=FormDesc^.Items;
	asm
	PUSH	ES
	PUSH	DS
	CLD		{auto increment}
	MOV	CX,word ptr maxX
	LES	DI,Odata
	LDS	SI,Idata
@@Loop:	LODSB			{prvni pulbyte}
	SHL	AL,4
	MOV	BL,AL
	ADD	SI,1
	LOOP	@@Hop
	STOSB			{licha delka-uloz posledni byte}
	JMP	@@Endl
@@Hop:  LODSB
	AND	AL,0Fh		{druhy pulbyte}
	OR	AL,BL
	ADD	SI,1
	STOSB
	LOOP	@@Loop
@@Endl:	POP	DS
	POP	ES
	end;
end;


Procedure conv16_8(FormDesc:PBasicFormStruct;Idata,OData:Pointer);
var MaxX:Word;
begin
MaxX:=FormDesc^.Items;
	asm
	PUSH	ES
	PUSH	DS
	CLD		{auto increment}
	MOV	CX,word ptr maxX
	LES	DI,Odata
	LDS	SI,IData

@@Loop8:LODSW
	STOSB
	LOOP	@@Loop8
	POP	DS
	POP	ES
	end;
end;


Procedure conv32_8(FormDesc:PBasicFormStruct;Idata,OData:Pointer);
var MaxX:Word;
begin
MaxX:=FormDesc^.Items;
	asm
	PUSH	ES
	PUSH	DS
	CLD		{auto increment}
	MOV	CX,word ptr maxX
	LES	DI,Odata
	LDS	SI,IData

@@Loop8:LODSW
	LODSW
	STOSB
	LOOP	@@Loop8
	POP	DS
	POP	ES
	end;
end;
{$endif}


Procedure MoveX_X(FormDesc:PBasicFormStruct;Idata,OData:Pointer);
begin
  move(Idata^,OData^,(longint(FormDesc^.SrcPlanes)*FormDesc^.Items +7) div 8);
end;


{---------Implicitni procedury pro konverzi------------}

type ReadGrayPix =Function(p:pointer;x:word):Longint;
     WriteGrayPix=Procedure (p:pointer;x:word;n:Longint);

     ReadRGBPix =Procedure (p:pointer;x:word;var RGB:RGB_b);
     WriteRGBPix=Procedure (p:pointer;x:word;RGB:RGB_b);

Procedure SetPix_1G(p:pointer;x:word;n:Longint); far;
var b:^byte absolute p;
begin
 inc(b,x shr 3);
 if n=0 then b^:=b^ and not($80 shr(x and $7))
	else b^:=b^ or ($80 shr(x and $7));
end;

Function GetPix_1G(p:pointer;x:word):Longint;	far;
var b:^byte absolute p;
begin
 inc(b,x shr 3);
 GetPix_1G:=0;
 if(b^ and ($80 shr(x and $7)) <> 0) then GetPix_1G:=1;
end;

Procedure SetPix_2G(p:pointer;x:word;n:Longint); far;
var b:^byte absolute p;
    v:byte;
begin
 v:=n;
 if n>3 then v:=3;
 inc(b,x shr 2);
 case x and 3 of
	0:begin;v:=v shl 6; b^:=b^ and $3F; end;
	1:begin;v:=v shl 4; b^:=b^ and $CF; end;
	2:begin;v:=v shl 2; b^:=b^ and $F3; end;
	3:b^:=b^ and $FC;
       end;
 b^:=b^ or v;
end;


Function GetPix_2G(p:pointer;x:word):Longint;	far;
var b:^byte absolute p;
    v:byte;
begin
 inc(b,x shr 2);
 v:=b^;
 case x and 3 of
	0:v:=v shr 6;
	1:v:=v shr 4;
	2:v:=v shr 2;
       end;
 GetPix_2G:=v and 3;
end;



Procedure SetPix_4G(p:pointer;x:word;n:Longint); far;
var b:^byte absolute p;
begin
 inc(b,x shr 1);
 if odd(x) then b^:=(b^ and $F0) or (n and $0F)
	   else b^:=(b^ and $0F) or ((n shl 4) and $F0)
end;

Function GetPix_4G(p:pointer;x:word):Longint;	far;
var b:^byte absolute p;
begin
 inc(b,x shr 1);
 if odd(x) then GetPix_4G:=b^ and $0F
	   else GetPix_4G:=b^ shr 4;
end;

Procedure SetPix_8G(p:pointer;x:word;n:Longint); far;
var b:^byte absolute p;
begin
 inc(b,x);
 b^:=byte(n);
end;

Function GetPix_8G(p:pointer;x:word):Longint;	far;
var b:^byte absolute p;
begin
 inc(b,x);
 GetPix_8G:=b^;
end;

Procedure SetPix_16G(p:pointer;x:word;n:Longint); far;
var b:^word absolute p;
begin
 inc(b,x);
 b^:=word(n);
end;

Function GetPix_16G(p:pointer;x:word):Longint;	far;
var b:^word absolute p;
begin
 inc(b,x);
 GetPix_16G:=b^;
end;

Procedure SetPix_32G(p:pointer;x:word;n:Longint); far;
var l:^longint absolute p;
begin
 inc(l,x);
 l^:=n;
end;

Function GetPix_32G(p:pointer;x:word):Longint;	far;
var l:^longint absolute p;
begin
 inc(l,x);
 GetPix_32G:=l^;
end;


Procedure SetPix_8C(p:pointer;x:word;c:RGB_b);	far;
var b:^byte absolute p;
begin
 inc(b,x);
 b^:=(c.R and $E0) + ((c.G and $E0)shr 3) + (c.B shr 6);
end;

Procedure GetPix_8C(p:pointer;x:word;var c:RGB_b);	far;
var b:^byte absolute p;
begin
 inc(b,x);
 c.R:=b^ and $E0;
 c.G:=(b^ shl 3) and $E0;
 c.B:=b^ shl 6;
end;


Procedure SetPix_24C(p:pointer;x:word;c:RGB_b);	far;
var b:^byte absolute p;
begin
 inc(b,3*x);
 b^:=c.R; inc(b);
 b^:=c.G; inc(b);
 b^:=c.B; inc(b);
end;

Procedure GetPix_24C(p:pointer;x:word;var c:RGB_b);	far;
var b:^byte absolute p;
begin
 inc(b,3*x);
 c.R:=b^; inc(b);
 c.G:=b^; inc(b);
 c.B:=b^; inc(b);
end;




Procedure C_XX_YY(FormDesc:PBasicFormStruct;Idata,OData:Pointer);
type RGB_w=record
	R,G,B:Byte;
	end;

var nRGB:RGB_b;
    nGray:Longint;
    x:word;
    k:shortint;
    ConvTyp:Byte;

    ReadPix:ReadGrayPix;
    ReadCPix:ReadRGBPix absolute readpix;
    WritePix:WriteGrayPix;
    WriteCPix:WriteRGBPix absolute WritePix;

begin
  if (Idata=nil)or(Odata=nil) then exit;

  ConvTyp:=0;

  if FormDesc^.SrcTyp='P' then
	begin
	case FormDesc^.SrcPlanes of
		1:ReadPix:=GetPix_1G;
		2:ReadPix:=GetPix_2G;
		4:ReadPix:=GetPix_4G;
		8:ReadPix:=GetPix_8G;
	       16:ReadPix:=GetPix_16G;
	       32:ReadPix:=GetPix_32G;
	      else exit;
	      end;
	ConvTyp:=$30;
	if FormDesc^.palette=nil then FormDesc^.SrcTyp:='G';
	end;


  if (FormDesc^.SrcTyp='G')or(FormDesc^.SrcTyp='B') then
	begin
	case FormDesc^.SrcPlanes of
		1:ReadPix:=GetPix_1G;
		2:ReadPix:=GetPix_2G;
		4:ReadPix:=GetPix_4G;
		8:ReadPix:=GetPix_8G;
	       16:ReadPix:=GetPix_16G;
	       32:ReadPix:=GetPix_32G;
	      else exit;
	      end;
	ConvTyp:=$10;
	end;
  if FormDesc^.SrcTyp='C' then
	begin
	case FormDesc^.SrcPlanes of
		8:ReadCPix:=GetPix_8C;
	       24:ReadCPix:=GetPix_24C;
	      else exit;
	      end;
	ConvTyp:=$20;
	end;


  if (FormDesc^.DestTyp='G')or(FormDesc^.DestTyp='B') then
	begin
	case FormDesc^.DestPlanes of
		1:WritePix:=SetPix_1G;
		2:WritePix:=SetPix_2G;
		4:WritePix:=SetPix_4G;
		8:WritePix:=SetPix_8G;
	       16:WritePix:=SetPix_16G;
	       32:WritePix:=SetPix_32G;
	      else exit;
	      end;
	ConvTyp:=ConvTyp or $01;
	end;
  if FormDesc^.DestTyp='C' then
	begin
	case FormDesc^.DestPlanes of
		8:WriteCPix:=SetPix_8C;
	       24:WriteCPix:=SetPix_24C;
	      else exit;
	      end;
	ConvTyp:=ConvTyp or $02;
	end;

  if (FormDesc^.DestTyp=FormDesc^.SrcTyp) and
     (FormDesc^.DestPlanes=FormDesc^.SrcPlanes) then ConvTyp:=0; {only copying}

  case ConvTyp of
	$00:move(Idata^,OData^,(longint(FormDesc^.DestPlanes)*FormDesc^.Items+7)div 8);
	$11:begin	{Gray -> Gray}
	    k:=integer(FormDesc^.DestPlanes)-FormDesc^.SrcPlanes;
	    if ((FormDesc^.Options and NoScale)<>0) then k:=0;
	    for x:=0 to FormDesc^.Items - 1 do
		begin
		nGray:=ReadPix(Idata,x);
		if k<0 then nGray:=nGray shr (-k);
		if k>0 then nGray:=nGray shl k;
		WritePix(Odata,x,nGray);
		end;
	    end;
	$12:begin	{Gray -> RGB}
	    k:=integer(FormDesc^.DestPlanes div 3)-FormDesc^.SrcPlanes;
	    for x:=0 to FormDesc^.Items - 1 do
		begin
		nGray:=ReadPix(Idata,x);
		if k<0 then nGray:=nGray shr (-k);
		if k>0 then nGray:=nGray shl k;
		nRGB.R:=nGray;
		nRGB.G:=nGray;
		nRGB.B:=nGray;
		WriteCPix(Odata,x,nRGB);
		end;
	    end;
	$21:begin	{RGB -> Gray}
	    for x:=0 to FormDesc^.Items - 1 do
		begin
		ReadCPix(Idata,x,nRGB);
		nGray:=nRGB.R+nRGB.G+nRGB.B;
		WritePix(Odata,x,nGray);
		end;
	    end;
	$22:begin	{RGB -> RGB}
	    for x:=0 to FormDesc^.Items - 1 do
		begin
		ReadCPix(Idata,x,nRGB);
		WriteCPix(Odata,x,nRGB);
		end;
	    end;
	$32:begin	{Palette -> RGB}
	    for x:=0 to FormDesc^.Items - 1 do
		begin
		nGray:=ReadPix(Idata,x);
		WriteCPix(Odata,x,FormDesc^.palette^[nGray]);
		end;
	    end;
      end;

end;


end.


(*
Procedure picture.FormRD(i:integer;FData:Pointer);
type poleW=array[0..32068] of word;
var MaxX:Word;
    j:Word absolute MaxX;
    Line:Pointer;
    DataW:^poleW absolute FData;
begin
if data=nil then exit;
if i>=y then i:=y-1;
if i<0 then i:=0;
MaxX:=X;
Line:=data^[i];
case Planes of
      1:asm
	PUSH	ES
	PUSH	DS
	CLD		{auto increment}
	LES	DI,FData
	LDS	SI,Line
	XOR	CX,CX
@Loop1: MOV	BL,byte ptr DS:SI
	INC	SI
@Lop1:	XOR	AX,AX
	SHL	BL,1
	ADC	AL,0
	STOSW
	INC	CX
	CMP	CX,word ptr MaxX
	JGE	@Konec1
	TEST	CX,7
	JNZ	@Lop1
	JMP	@Loop1
@Konec1:POP	DS
	POP	ES
	end;
      2:asm
	PUSH	ES
	PUSH	DS
	CLD		{auto increment}
	MOV	CX,word ptr maxX
	LES	DI,FData
	LDS	SI,Line
	XOR	AX,AX
@Loop2: MOV	AL,byte ptr DS:SI
	MOV	DL,AL
	SHR	AL,6
	STOSW
	DEC	CX
	JCXZ	@Konec2
	MOV	AL,DL
	SHR	AL,4
	AND	AL,3
	STOSW
	DEC	CX
	JCXZ	@Konec2
	MOV	AL,DL
	SHR	AL,2
	AND	AL,3
	STOSW
	DEC	CX
	JCXZ	@Konec2
	LODSB
	AND	AL,03
	STOSW
	LOOP	@Loop2
@Konec2:POP	DS
	POP	ES
	end;
      4:asm
	PUSH	ES
	PUSH	DS
	CLD		{auto increment}
	MOV	CX,word ptr maxX
	LES	DI,FData
	LDS	SI,Line
	XOR	AX,AX
@Loop4: MOV	AL,byte ptr DS:SI
	SHR	AL,4
	STOSW
	DEC	CX
	JCXZ	@Konec4
	LODSB
	AND	AL,0Fh
	STOSW
	LOOP	@Loop4
@Konec4:POP	DS
	POP	ES
	end;
      8:asm
	xor ax,ax
	PUSH	ES
	PUSH	DS
	CLD		{auto increment}
	MOV	CX,word ptr maxX
	LES	DI,FData
	LDS	SI,Line

@@Loop8:LODSB
	STOSW
	LOOP	@@Loop8

	POP	DS
	POP	ES
        end;
     16:asm
	PUSH	ES
	PUSH	DS
	CLD		{auto increment}
	MOV	CX,word ptr maxX
	JCXZ	@Endl16
	LES	DI,FData
	LDS	SI,Line

        REP MOVSW

@Endl16:POP	DS
	POP	ES
	end;
     else For j:=0 to x-1 do DataW^[j]:=Pixel(self,j,i); {nouzove reseni}
     end;
end;
*)


(*    else begin
	 ukRadekW2:=pointer(data^[j]);
	 ukpixel:=pointer(Newpict.data^[0]);
	 asm
	 push	ds
	 push	es

	 mov	ax,offsetX;
	 mov	CX,MaxGx
	 les	di,ukpixel
	 lds	si,ukRadekW2

	 add	si,ax
	 add	si,ax
	 add	si,ax           ;{R R R G G G B B}
@loopTc: lodsb			;{R value}
	 and	al,0E0h
	 mov	ah,al
	 lodsb			;{G value}
	 shr	al,3
	 and	al,1Ch
	 or	ah,al
	 lodsb			;{B value}
	 shr	al,6
	 or	al,ah
	 stosb
	 loop	@loopTc

	 pop	es
	 pop	ds
	 end;
	 end;  *)